/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.FirstOrder;

public class FirstOrderTest
extends AbstractFilterTest {
    private static double EXPR_DELTA = 0.001;

    public FirstOrderTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("6,3");
    }

    public Filter getFilter(String rangelist) {
        try {
            FirstOrder af = new FirstOrder();
            af.setAttributeIndices(rangelist);
            return af;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            FirstOrderTest.fail("Exception setting attribute range: " + rangelist + "\n" + ex.getMessage());
            return null;
        }
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(6);
        test.setClassType(1);
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter("6,3");
        Instances result = this.useFilter();
        FirstOrderTest.assertEquals(this.m_Instances.numAttributes() - 1, result.numAttributes());
        int i = 0;
        while (i < result.numInstances()) {
            Instance orig = this.m_Instances.instance(i);
            if (orig.isMissing(5) || orig.isMissing(2)) {
                FirstOrderTest.assertTrue("Instance " + (i + 1) + " should have been ?", result.instance(i).isMissing(4));
            } else {
                FirstOrderTest.assertEquals(orig.value(5) - orig.value(2), result.instance(i).value(4), EXPR_DELTA);
            }
            ++i;
        }
    }

    public void testTypical2() {
        this.m_Filter = this.getFilter("3,6");
        Instances result = this.useFilter();
        FirstOrderTest.assertEquals(this.m_Instances.numAttributes() - 1, result.numAttributes());
        int i = 0;
        while (i < result.numInstances()) {
            Instance orig = this.m_Instances.instance(i);
            if (orig.isMissing(5) || orig.isMissing(2)) {
                FirstOrderTest.assertTrue("Instance " + (i + 1) + " should have been ?", result.instance(i).isMissing(4));
            } else {
                FirstOrderTest.assertEquals(orig.value(5) - orig.value(2), result.instance(i).value(4), EXPR_DELTA);
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(FirstOrderTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(FirstOrderTest.suite());
    }
}

